% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo-tagging.R
\name{geotag_tweets}
\alias{geotag_tweets}
\title{Launches the geo-tagging loop}
\usage{
geotag_tweets(tasks = get_tasks())
}
\arguments{
\item{tasks}{Tasks object for reporting progress and error messages, default: get_tasks()}
}
\value{
The list of tasks updated with produced messages
}
\description{
This function will geolocate all tweets before the current hour that have not been already geolocated
}
\details{
Geolocates tweets by collection date, and stores the result in the tweets/geolocated folder.
It starts from the last geolocated date until the last collected tweet. When running on a day that has been partially geolocated,
it will ignore tweets that have already been processed. 

The geolocation is applied to several fields of tweets: text, original text (if retweet or quote), user description, user declared location, user biography, API location. For each field it will perform the following steps:
\itemize{
  \item{Evaluate the part of the text which is more likely to be a location using an unsupervised machine learning and language dependent model trained during \code{\link{update_languages}}}
  \item{Match the selected text against a Lucene index of GeoNames database built during \code{\link{update_geonames}}}
  \item{Return the location with the highest matching score. For more information about the scoring process please refer to the epitweetr vignette}
}

This algorithm has mainly been developed in Spark. 

A prerequisite to this function is that the \code{\link{search_loop}} must already have stored collected tweets in the search folder and that the tasks \code{\link{download_dependencies}}, 
\code{\link{update_geonames}} and \code{\link{update_languages}} have successfully been run.
Normally this function is not called directly by the user but from the \code{\link{detect_loop}} function.
}
\examples{
if(FALSE){
   library(epitweetr)
   # setting up the data folder
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())

   # geolocating last tweets
   tasks <- geotag_tweets()
}
}
\seealso{
\code{\link{download_dependencies}}

 \code{\link{update_geonames}}

 \code{\link{update_languages}}

 \code{\link{detect_loop}}
 
 \code{\link{aggregate_tweets}}

 \code{\link{get_tasks}}
}
