% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{svapca}
\alias{svapca}
\title{Principal component analysis(PCA) for SVA corrected data and raw data}
\usage{
svapca(list, center = T, scale = T, lv = NULL)
}
\arguments{
\item{list}{results from svacor function}

\item{center}{parameters for PCA}

\item{scale}{parameters for scale}

\item{lv}{group information}
}
\value{
plot
}
\description{
Principal component analysis(PCA) for SVA corrected data and raw data
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file("cdf", package = "faahKO")
cdffiles <- list.files(cdfpath, recursive = TRUE, full.names = TRUE)
xset <- xcmsSet(cdffiles)
xset <- group(xset)
xset2 <- retcor(xset, family = "symmetric", plottype = "mdevden")
xset2 <- group(xset2, bw = 10)
xset3 <- fillPeaks(xset2)
df <- svacor(xset3)
svapca(df)
}
}
\seealso{
\code{\link{svacor}}, \code{\link{svaplot}}, \code{\link{svabatch}}
}
