% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotEnrich}
\alias{plotEnrich}
\title{plotEnrich}
\usage{
plotEnrich(
  df,
  showTerms = 20,
  numChar = 40,
  y = "Count",
  orderBy = "P.value",
  xlab = NULL,
  ylab = NULL,
  title = NULL
)
}
\arguments{
\item{df}{(Required). A single data.frame from a list of Enrichr output.}

\item{showTerms}{(Optional). Number of terms to show. Default is \code{20}.}

\item{numChar}{(Optional). A single integer. Default is \code{40}.
Indicates the number characters to keep in the term description.}

\item{y}{(Optional). A character string. Default is \code{"Count"}.
Indicates the variable that should be mapped to the y-axis.
It can be either \code{"Count"} or \code{"Ratio"}.}

\item{orderBy}{(Optional). A character string. Default is \code{"P.value"}.
Indicates how to order the Enrichr results before subsetting to keep top \code{N} terms.
It can be either \code{"P.value"} or \code{"Combined.Score"}.}

\item{xlab}{(Optional). A character string. Default is \code{NULL}.
Indicates the x-axis label.}

\item{ylab}{(Optional). A character string. Default is \code{NULL}.
Indicates the y-axis label.}

\item{title}{(Optional). A character string. Default is \code{NULL}
Indicates the main title for the graphic.}
}
\value{
A \code{\link{ggplot}}2 plot object
}
\description{
Visualise a Enrichr output as barplot
}
\details{
Visualise Enrichr result from a selected gene-set library as barplot.
}
\examples{
if (getOption("enrichR.live")) {
  dbs <- listEnrichrDbs()
  enrichRLive <- TRUE
  if (is.null(dbs)) enrichRLive <- FALSE
  dbs <- c("GO_Molecular_Function_2018", "GO_Cellular_Component_2018",
           "GO_Biological_Process_2018")
  enriched <- enrichr(c("Runx1", "Gfi1", "Gfi1b", "Spi1", "Gata1", "Kdr"), dbs)
  # Plot top 20 terms from "GO_Biological_Process_2018" and ordered by P-value
  if (enrichRLive) {
    plotEnrich(enriched[[3]], showTerms = 20, numChar = 50, y = "Count",
               orderBy = "P.value")
  }
}
}
\seealso{
\code{\link[ggplot2]{ggplot}}
}
\author{
I-Hsuan Lin \email{i-hsuan.lin@manchester.ac.uk}
}
