% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.enspls.R
\name{plot.enspls.od}
\alias{plot.enspls.od}
\title{Plot enspls.od object}
\usage{
\method{plot}{enspls.od}(x, criterion = c("quantile", "sd"), prob = 0.05,
  sdtimes = 3L, main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{enspls.od}.}

\item{criterion}{Criterion of being classified as an outlier,
can be \code{"quantile"} or \code{"sd"}.}

\item{prob}{Quantile probability as the cut-off value.}

\item{sdtimes}{Times of standard deviation as the cut-off value.}

\item{main}{Plot title.}

\item{...}{Additional graphical parameters for \code{\link{plot}}.}
}
\description{
Plot enspls.od object
}
\examples{
data("logd1k")
x = logd1k$x
y = logd1k$y

set.seed(42)
od = enspls.od(x, y, reptimes = 4, maxcomp = 2)
plot(od, criterion = "quantile", prob = 0.1)
plot(od, criterion = "sd", sdtimes = 1)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enspls.od}} for outlier detection with
ensemble sparse partial least squares regressions.
}

