% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.enpls.R
\name{print.enpls.fs}
\alias{print.enpls.fs}
\title{Print enpls.fs Object}
\usage{
\method{print}{enpls.fs}(x, sort = TRUE, nvar = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{enpls.fs}.}

\item{sort}{Should the variables be sorted in decreasing order of importance?}

\item{nvar}{How many variables to show? Ignored if \code{sort = FALSE}.}

\item{...}{Additional parameters for \code{\link{print}}.}
}
\description{
Print enpls.fs object.
}
\examples{
data("alkanes")
x = alkanes$x
y = alkanes$y

set.seed(42)
fs = enpls.fs(x, y, MCtimes = 100)
print(fs)
print(fs, nvar = 10L)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enpls.fs}} for feature selection with
ensemble partial least squares regression.
}

