% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalThresholdStats.r
\name{evalThresholdStats}
\alias{evalThresholdStats}
\title{Thresholded evaluation statistics}
\usage{
evalThresholdStats(
  thresholds,
  pres,
  contrast,
  presWeight = rep(1, length(pres)),
  contrastWeight = rep(1, length(contrast)),
  delta = 0.001,
  na.rm = FALSE,
  bg = NULL,
  bgWeight = NULL,
  ...
)
}
\arguments{
\item{thresholds}{Numeric or numeric vector. Threshold(s) at which to calculate sensitivity and specificity.}

\item{pres}{Numeric vector. Predicted values at test presences}

\item{contrast}{Numeric vector. Predicted values at background/absence sites.}

\item{presWeight}{Numeric vector same length as \code{pres}. Relative weights of presence sites. The default is to assign each presence a weight of 1.}

\item{contrastWeight}{Numeric vector same length as \code{contrast}. Relative weights of background sites. The default is to assign each presence a weight of 1.}

\item{delta}{Positive numeric >0 in the range [0, 1] and usually very small. This value is used only if calculating the SEDI threshold when any true positive rate or false negative rate is 0 or the false negative rate is 1. Since SEDI uses log(x) and log(1 - x), values of 0 and 1 will produce \code{NA}s. To obviate this, a small amount can be added to rates that equal 0 and subtracted from rates that equal 1.}

\item{na.rm}{Logical. If \code{TRUE} then remove any presences and associated weights and background predictions and associated weights with \code{NA}s.}

\item{bg}{Same as \code{contrast}. Included for backwards compatibility. Ignored if \code{contrast} is not \code{NULL}.}

\item{bgWeight}{Same as \code{contrastWeight}. Included for backwards compatibility. Ignored if \code{contrastWeight} is not \code{NULL}.}

\item{...}{Other arguments (unused).}
}
\value{
8-column matrix with the following named columns. \emph{a} = weight of presences >= threshold, \emph{b} = weight of backgrounds >= threshold, \emph{c} = weight of presences < threshold, \emph{d} = weight of backgrounds < threshold, and \emph{N} = sum of presence and background weights.
\itemize{
		\item \code{'threshold'}: Threshold
		\item \code{'sensitivity'}: Sensitivity (\emph{a} / (\emph{a} + \emph{c}))
		\item \code{'specificity'}: Specificity (\emph{d} / (\emph{d} + \emph{b}))
		\item \code{'ccr'}: Correct classification rate ((\emph{a} + \emph{d}) / \emph{N})
		\item \code{'ppp'}: Positive predictive power (\emph{a} / (\emph{a} + \emph{b}))
		\item \code{'npp'}: Negative predictive power (\emph{d} / (\emph{c} + \emph{d}))
		\item \code{'mr'}: Misclassification rate ((\emph{b} + \emph{c}) / \emph{N})
}
Fielding, A.H. and J.F. Bell. 1997. A review of methods for the assessment of prediction errors in conservation presence/absence models. \emph{Environmental Conservation} 24:38-49. \doi{10.1017/S0376892997000088}
}
\description{
This function calculates a series of evaluation statistics based on a threshold or thresholds used to convert continuous predictions to binary predictions.
}
\examples{
set.seed(123)

# set of bad and good predictions at presences
bad <- runif(100)^2
good <- runif(100)^0.1
hist(good, breaks=seq(0, 1, by=0.1), border='green', main='Presences')
hist(bad, breaks=seq(0, 1, by=0.1), border='red', add=TRUE)
pres <- c(bad, good)
contrast <- runif(1000)
thresholds <- c(0.1, 0.5, 0.9)
evalThresholdStats(thresholds, pres, contrast)

# upweight bad predictions
presWeight <- c(rep(1, 100), rep(0.1, 100))
evalThresholdStats(thresholds, pres, contrast, presWeight=presWeight)

# upweight good predictions
presWeight <- c(rep(0.1, 100), rep(1, 100))
evalThresholdStats(thresholds, pres, contrast, presWeight=presWeight)
}
\seealso{
\code{\link[predicts]{threshold}}, \code{\link[predicts]{pa_evaluate}}, \code{\link{evalAUC}}, \code{\link{evalMultiAUC}}, \code{\link{evalContBoyce}}, \code{\link{evalThreshold}}, \code{\link{evalTjursR2}}, \code{\link{evalTSS}}
}
