% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.engression.R
\name{print.engression}
\alias{print.engression}
\title{Print an Engression Model Object}
\usage{
\method{print}{engression}(x, ...)
}
\arguments{
\item{x}{A trained engression model returned from the engressionfit function.}

\item{...}{additional arguments (currently ignored)}
}
\value{
This function does not return anything. It prints a summary of the model,
including information about its architecture and training process, and the loss
values achieved at several epochs during training.
}
\description{
This function is a utility that displays a summary of a fitted Engression model object.
}
\examples{
\donttest{
  n = 1000
  p = 5

  X = matrix(rnorm(n*p),ncol=p)
  Y = (X[,1]+rnorm(n)*0.1)^2 + (X[,2]+rnorm(n)*0.1) + rnorm(n)*0.1
  
  ## fit engression object
  engr = engression(X,Y)
  print(engr)
}

}
