% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/least-cost_path.R
\name{en_lcp}
\alias{en_lcp}
\title{Compute least-cost paths}
\usage{
en_lcp(en, or, dest, simulate_random_points = FALSE, rep = 10, plot = TRUE)
}
\arguments{
\item{en}{an enerscape object obtained with \code{enerscape()}.}

\item{or}{origin point.}

\item{dest}{destination point.}

\item{simulate_random_points}{if to simulate least-cost path among random
points. default = FALSE.}

\item{rep}{number or random origin and destination points if
\code{simulate_random_points = TRUE}. default = 10.}

\item{plot}{if to plot the output.}
}
\value{
A list with point locations, least-cost path as SpatialLines, energy
  costs and distances.
}
\description{
Calculate the least-cost path (lcp) between origin and destination
}
\details{
If \code{or} and \code{dest} are not specified, the least-cost path
  is specified by setting \code{simulate_random_points = TRUE} and \code{rep}
  equal to the number of random paths to compute.
}
\examples{
library(raster)
data("volcano")
dem <- raster(volcano)
en <- enerscape(dem, 10, unit = "kcal", neigh = 16)
p <- xyFromCell(dem, sample(ncell(dem), 2))
lcp <- en_lcp(en, or = p[1, ], dest = p[2, ])
}
