% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pamr.r
\name{importance_pamr}
\alias{importance_pamr}
\title{Feature importance of nearest shrunken centroids.}
\usage{
importance_pamr(object, threshold, thres_fun = max, ...)
}
\arguments{
\item{object}{Fitted pamr classifier}

\item{threshold}{Threshold to use for classification. This argument is only
needed if you want to override the value set during model fitting.}

\item{thres_fun}{Threshold selection function. Only needed if you want to
override the function set during model fitting.}

\item{...}{Sent to \code{\link[pamr]{pamr.predict}}.}
}
\value{
A data frame of feature importance scores.
}
\description{
Calculated as the absolute difference between the overall centroid and a
class-wise shrunken centroid (which is the same for both classes except sign).
}
\details{
In case multiple thresholds give the same error the largest one is chosen
(i.e. the one keeping the fewest features).
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{fit_pamr}},
  \code{\link{predict_pamr}}, \code{\link{modeling_procedure}}
}

