% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.r
\name{fit}
\alias{fit}
\title{Fit a model}
\usage{
fit(procedure, x, y, ..., .verbose = getOption("emil_verbose", FALSE))
}
\arguments{
\item{procedure}{Modeling procedure, or list of modeling procedures, as
produced by \code{\link{modeling_procedure}}.}

\item{x}{Dataset, observations as rows and descriptors as columns.}

\item{y}{Response vector.}

\item{...}{Sent to \code{\link{tune}}, in case tuning is required,
which will pass them on to \code{\link{evaluate}}.}

\item{.verbose}{Whether to print an activity log. Set to \code{-1} to
suppress all messages.}
}
\value{
A list of fitted models.
}
\description{
Fits a model according to a modeling procedure. If the procedure contains
untuned parameters they will automatically be tuned prior to fitting.
}
\examples{
mod <- fit("lda", x=iris[-5], y=iris$Species)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{modeling_procedure}},
  \code{\link{evaluate}}, \code{\link{tune}},
  \code{\link[=predict.model]{predict}}, \code{\link{get_importance}}
}

