% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generate_hatchling_metric.R
\name{Generate_hatchling_metric}
\alias{Generate_hatchling_metric}
\title{Generate a data.frame that can be used as test value for searchR()}
\usage{
Generate_hatchling_metric(
  series = stop("A result object or names of series must be provided"),
  hatchling.metric = NULL,
  previous = NULL
)
}
\arguments{
\item{series}{Name of series or object from searchR()}

\item{hatchling.metric}{Size or mass at hatching. Will be recycled if necessary}

\item{previous}{Previous formated test data}
}
\value{
A data.frame with size or mass at hatching for each nest
}
\description{
Generate a data.frame that can be used as test value for searchR()
}
\details{
Generate_hatchling_metric Generate a data.frame that can be used as test value for searchR()
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p_SSM)
testsize1 <- Generate_hatchling_metric(resultNest_4p_SSM)
testsize2 <- Generate_hatchling_metric(series=resultNest_4p_SSM,  
	hatchling.metric=c(Mean=39.3, SD=1.92))
}
}
\author{
Marc Girondot
}
