% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomarkers.R
\name{get_synergy_biomarkers_per_cell_line}
\alias{get_synergy_biomarkers_per_cell_line}
\title{Get synergy biomarkers per cell line}
\usage{
get_synergy_biomarkers_per_cell_line(biomarkers.dirs)
}
\arguments{
\item{biomarkers.dirs}{a character vector of the biomarker directories, in the
form of \emph{\{path\}/cell_line_name/\{dir\}}. The cell line name directory
should be different for each element of the vector as we use it to fill in the
\code{rownames} of each cell line-specific \code{data.frame} object.
Inside each \emph{\{dir\}}, we read the synergy biomarkers from a file (if it
exists and is non-empty) with the name \emph{biomarkers_per_synergy}. This file
has as first row the node names (columns) while every next row starts with the row name
(drug combination name) followed by a series of numbers from the ternary set
\{1,-1,0\}, denoting thus which nodes where found as active biomarkers for that
synergy, inhibited or not at all as biomarkers.}
}
\value{
a list of cell line-specific data frames (each element
from the list takes its name from the respective cell line).
Each cell-line specific \code{data.frame} object has as rows the
\strong{true positive predicted synergies} for that particular cell line
and columns the network nodes (should be the same for all cell lines).
Possible values for each \emph{synergy-node}
element in each cell line-specific \code{data.frame} are either \emph{1}
(\emph{active state} biomarker), \emph{-1}
(\emph{inhibited state} biomarker) or \emph{0} (not a biomarker).
}
\description{
Use this function to get the synergy biomarkers for each cell line.
The biomarkers must be stored in a single file inside each given cell line-specific
directory.
}
