% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_get.R
\name{wrf_get}
\alias{wrf_get}
\title{Function to read variables of emission files}
\format{
array or raster object
}
\usage{
wrf_get(
  file = file.choose(),
  name = NA,
  as_raster = FALSE,
  raster_crs = "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs",
  raster_lev = 1,
  verbose = F
)
}
\arguments{
\item{file}{name of file interactively (default) or specified}

\item{name}{name of the variable (any variable) or time to return a POSIXlt object from model}

\item{as_raster}{return a raster instead of an array}

\item{raster_crs}{crs to use if as_raster is TRUE}

\item{raster_lev}{level for rasters from a 4D variable}

\item{verbose}{display additional information}
}
\description{
Read a variable
}
\examples{
{

# create the folder and emission file
dir.create(file.path(tempdir(), "EMISS"))
wrf_create(wrfinput_dir = system.file("extdata", package = "eixport"),
         wrfchemi_dir = file.path(tempdir(), "EMISS"))

# get the name of created file
files <- list.files(path = file.path(tempdir(), "EMISS"),
                   pattern = "wrfchemi",
                   full.names = TRUE)

# open, put some numbers and write
CO <- wrf_get(file = files[1], name = "E_CO")
CO[] = rnorm(length(CO))
wrf_put(file = files[1], name = "E_CO", POL = CO)
COr <- wrf_get(file = files[1], name = "E_CO", as_raster = TRUE)

}
}
\seealso{
\code{\link{wrf_plot}} and \code{\link{wrf_put}}
}
\author{
Daniel Schuch
}
