% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei_descriptives.R
\name{plot_bivariate}
\alias{plot_bivariate}
\title{Plot bivariate relationships between all combinations of candidates and
race/ethnicities}
\usage{
plot_bivariate(
  data,
  cand_cols,
  race_cols,
  corrs = FALSE,
  save = FALSE,
  path = ""
)
}
\arguments{
\item{data}{A data.frame() object containing precinct-level turnout data by
race and candidate}

\item{cand_cols}{A character vector listing the column names for turnout for
each candidate}

\item{race_cols}{A character vector listing the column names for turnout by
race}

\item{corrs}{A boolean indicating whether to include correlation coefficients
on the plot.}

\item{save}{A boolean indicating whether to save the plot to a file.}

\item{path}{A string to specify plot save location. Defaulted to
working directory}
}
\value{
ggplot object with bivariate plots faceted by candidate and race
}
\description{
Plot bivariate relationships between all combinations of candidates and
race/ethnicities
}
