% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{Weibull}
\alias{Weibull}
\alias{hweibull}
\alias{Hweibull}
\title{The (Cumulative) Hazard Function of a Weibull Distribution}
\usage{
hweibull(x, shape, scale = 1, log = FALSE)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{shape}{The shape parameter.}

\item{scale}{The scale parameter, defaults to 1.}

\item{log}{logical; if TRUE, the log of the hazard function is given.}
}
\value{
The (cumulative) hazard function, evaluated at x.
}
\description{
\code{hweibull} calculates the hazard function of a Weibull distribution,
and \code{Hweibull} calculates the corresponding cumulative hazard function.
}
\details{
See \link{dweibull}.
}
\examples{

hweibull(3, 2, 1)
dweibull(3, 2, 1) / pweibull(3, 2, 1, lower.tail = FALSE)
Hweibull(3, 2, 1)
-pweibull(3, 2, 1, log.p = TRUE, lower.tail = FALSE)

}
\seealso{
\code{\link{pweibull}}
}
\author{
Göran Broström
}
\keyword{survival}
