% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_parameters.R
\name{interpret_parameters}
\alias{interpret_parameters}
\alias{interpret_parameters.lm}
\title{Interpret of standardized slopes}
\usage{
interpret_parameters(model, ...)

\method{interpret_parameters}{lm}(
  model,
  parameters = NULL,
  interpretation = "funder2019",
  standardize_method = "refit",
  standardize_robust = FALSE,
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{...}{For \code{standardize_parameters()}, arguments passed to
\link[parameters:model_parameters]{parameters::model_parameters}, such as:
\itemize{
\item \code{ci_method}, \code{centrality} for Bayesian models...
\item \code{df_method} for Mixed models ...
\item \code{exponentiate}, ...
\item etc.
}}

\item{parameters}{A custom parameters table. If \code{NULL}, will use \code{\link[=standardize_parameters]{standardize_parameters()}} to get it.}

\item{interpretation}{Interpretation grid (i.e., the set of rules of thumb) used to interpret the effects.}

\item{standardize_method}{See \code{\link[=standardize_parameters]{standardize_parameters()}}.}

\item{standardize_robust}{See \code{\link[=standardize_parameters]{standardize_parameters()}}.}
}
\description{
Automated interpretation of standardized slopes.
}
\examples{
model <- lm(Sepal.Length ~ Species * Petal.Width, data = iris)
interpret_parameters(model)

}
