% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi_cramers_v.R
\name{phi}
\alias{phi}
\alias{cramers_v}
\title{Effect size for contingency tables}
\usage{
phi(x, y = NULL, CI = 0.95, adjust = FALSE, ...)

cramers_v(x, y = NULL, CI = 0.95, adjust = FALSE, ...)
}
\arguments{
\item{x}{a numeric vector or matrix. x and y can also both be factors.}

\item{y}{a numeric vector; ignored if x is a matrix. If x is a factor, y should be a factor of the same length.}

\item{CI}{Confidence Interval (CI) level}

\item{adjust}{Should the effect size be bias-corrected? Defaults to \code{FALSE}.}

\item{...}{Ignored.}
}
\value{
A data frame with the effect size(s) between 0-1, and confidence interval(s).
}
\description{
Compute Cramer's V and phi (\eqn{\phi}) from contingency tables.
}
\examples{
contingency_table <- as.table(rbind(c(762, 327, 468), c(484, 239, 477), c(484, 239, 477)))

phi(contingency_table)

cramers_v(contingency_table)

}
\seealso{
\code{\link[=chisq_to_phi]{chisq_to_phi()}} for details regarding estimation and CIs.
}
