% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_predicted.R
\name{average_predicted}
\alias{average_predicted}
\title{Average Predictions}
\usage{
average_predicted(
  X,
  pred,
  w = NULL,
  x_name = "x",
  breaks = "Sturges",
  right = TRUE,
  discrete_m = 5L,
  outlier_iqr = 2,
  seed = NULL,
  ...
)
}
\arguments{
\item{X}{A vector, matrix, or data.frame with variable(s) to be shown on the x axis.}

\item{pred}{A numeric vector of predictions.}

\item{w}{An optional numeric vector of weights.}

\item{x_name}{If \code{X} is a vector: what is the name of the variable? By default "x".}

\item{breaks}{An integer, vector, string or function specifying the bins
of the numeric X variables as in \code{\link[graphics:hist]{graphics::hist()}}. The default is "Sturges".
To allow varying values of \code{breaks} across variables, it can be a list of the
same length as \code{v}, or a \emph{named} list with \code{breaks} for certain variables.}

\item{right}{Should bins be right-closed? The default is \code{TRUE}.
Vectorized over \code{v}. Only relevant for numeric X.}

\item{discrete_m}{Numeric X variables with up to this number of unique values
should not be binned and treated as a factor (after calculating partial dependence)
The default is 5. Vectorized over \code{v}.}

\item{outlier_iqr}{Outliers of a numeric X are capped via the boxplot rule, i.e.,
outside \code{outlier_iqr} * IQR from the quartiles. The default is 2 is more
conservative than the usual rule to account for right-skewed distributions.
Set to 0 or \code{Inf} for no capping. Note that at most 10k observations are sampled
to calculate quartiles. Vectorized over \code{v}.}

\item{seed}{Optional random seed (an integer) used for capping X based on quantiles
calculated from a subsample of 10k observations.}

\item{...}{Currently unused.}
}
\value{
A list (of class "EffectData") with a data.frame of statistics per feature. Use
single bracket subsetting to select part of the output.
}
\description{
Calculates average predictions over the values of one or multiple
\code{X} variables. Shows the combined effect of a feature and other (correlated)
features.
}
\details{
The function is a convenience wrapper around \code{\link[=feature_effects]{feature_effects()}}.
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
M <- average_predicted(iris[2:5], pred = predict(fit, iris), breaks = 5)
M
M |> plot()
}
\references{
Apley, Daniel W., and Jingyu Zhu. 2016. \emph{Visualizing the Effects of Predictor Variables in Black Box Supervised Learning Models.}
Journal of the Royal Statistical Society Series B: Statistical Methodology,
82 (4): 1059–1086. doi:10.1111/rssb.12377.
}
\seealso{
\code{\link[=feature_effects]{feature_effects()}}
}
