% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_correction.R
\name{eem_inner_filter_effect}
\alias{eem_inner_filter_effect}
\title{Inner-filter effect correction}
\usage{
eem_inner_filter_effect(eem, absorbance, pathlength = 1)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{absorbance}{A data frame with:

  \describe{ \item{wavelength}{A numeric vector containing wavelenghts.}
  \item{...}{One or more numeric vectors containing absorbance spectra.}}}

\item{pathlength}{A numeric value indicating the pathlength (in cm) of the
cuvette used for fluorescence measurement. Default is 1 (1cm).}
}
\value{
An object of class \code{eemlist}.

An object of class \code{eem} containing: \itemize{ \item sample The
  file name of the eem. \item x A matrix with fluorescence values. \item em
  Emission vector of wavelengths. \item ex Excitation vector of wavelengths.
  }
}
\description{
Inner-filter effect correction
}
\section{Names matching}{


  The names of \code{absorbance} variables are expected to match those of the
  eems. If the appropriate absorbance spectrum is not found, an uncorrected
  eem will be returned and a warning message will be printed.
}

\section{Sample dilution}{


  Kothawala et al. 2013 have shown that a 2-fold dilution was requiered for
  sample presenting total absorbance > 1.5. Accordingly, a message will warn
  the user if total absorbance is greater than this threshold.
}
\examples{
library(eemR)
data("absorbance")

folder <- system.file("extdata/cary/scans_day_1", package = "eemR")
eems <- eem_read(folder)
eems <- eem_extract(eems, "nano", remove = TRUE) # Remove the blank sample

## Remove scattering (1st order)
eems <- eem_remove_scattering(eems, "rayleigh")

eems_corrected <- eem_inner_filter_effect(eems, absorbance = absorbance, pathlength = 1)

op <- par(mfrow = c(2, 1))
plot(eems, which = 1)
plot(eems_corrected, which = 1)
par(op)

}
\references{
Parker, C. a., & Barnes, W. J. (1957). Some experiments with
  spectrofluorimeters and filter fluorimeters. The Analyst, 82(978), 606.
  \url{http://doi.org/10.1039/an9578200606}

  Kothawala, D. N., Murphy, K. R., Stedmon, C. A., Weyhenmeyer, G. A., &
  Tranvik, L. J. (2013). Inner filter correction of dissolved organic matter
  fluorescence. Limnology and Oceanography: Methods, 11(12), 616-630.
  \url{http://doi.org/10.4319/lom.2013.11.616}
}

