% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textInput3.R
\name{dateInput3}
\alias{dateInput3}
\title{Create a side-by-side dateInput}
\usage{
dateInput3(inputId, label, width = 100, ...)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{width}{The width of the input in pixel}

\item{...}{arguments to be passed to dateInput}
}
\description{
Create a side-by-side dateInput
}
\examples{
library(shiny)
# Only run examples in interactive R sessions
if (interactive()) {
  ui <- fluidPage(
         label3("Welcome"),
         dateInput3("date", "date"),
         verbatimTextOutput("value")
  )
  server <- function(input, output) {
        output$value <- renderText({ input$date })
  }
  shinyApp(ui, server)
}
}
