% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allot.R
\name{allot_units}
\alias{allot_units}
\title{Define allotment of units to nested units}
\usage{
allot_units(.edibble, ..., .record = TRUE)
}
\arguments{
\item{.edibble}{An edibble design which should have units, treatments and allotment defined.}

\item{...}{A two-sided formula.}

\item{.record}{Whether to record the step.}
}
\value{
Return an edibble design.
}
\description{
This function adds the edges between factor nodes to describe the
high-level relationship between factors.
This function does not actually assign edges between level nodes.
}
\examples{
design() \%>\%
  set_units(block = 10,
            plot = 20) \%>\%
  allot_units(block ~ plot)

}
\seealso{
assign_fcts

Other user-facing functions: 
\code{\link{allot_trts}()},
\code{\link{design}()},
\code{\link{expect_rcrds}()},
\code{\link{export_design}()},
\code{\link{serve_table}()},
\code{\link{set_rcrds}()},
\code{\link{set_trts}()},
\code{\link{set_units}()}
}
\concept{user-facing functions}
