% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infant_coefs.R
\docType{data}
\name{infant_mat_sev}
\alias{infant_mat_sev}
\title{Infant Maturity/Severity Factors - Table 9}
\format{An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with
25 rows and 8 columns
\describe{
\item{mat}{Infant maturity level. Can be extremely immature, immature,
premature multiples, term, or age 1}
\item{sev}{Infant severity level. 1-5}
\item{used}{Whether or not the category is used in the RA model}
\item{plat, gold, silver, bronze, cat}{Maturity/severity risk score for
each metal level}
}}
\source{
Most recent DIY entry at:
\url{https://www.cms.gov/cciio/Resources/Regulations-and-Guidance/index} \cr
Data import and cleaning at:
\url{https://github.com/ArctiCondor/edgedata/tree/master/data-raw}
}
\usage{
infant_mat_sev
}
\description{
A dataset containing the infant model maturity/severity factors for the risk
adjustment model. Risk scores are done a little differently in the infant
model. Instead of grouping/applying a hierarchy to condition categories,
infants have all conditions grouped into 5 severity levels (1-5). They also
get a maturity level which corresponds to weeks of gestation at which they
were born. There is also a maturity category for age 1.
}
\seealso{
Other factors: 
\code{\link{adult_demo}},
\code{\link{adult_enroll_dur}},
\code{\link{adult_group}},
\code{\link{adult_hcc}},
\code{\link{adult_interaction}},
\code{\link{adult_rxc_hcc_inter}},
\code{\link{adult_rxc}},
\code{\link{child_demo}},
\code{\link{child_group}},
\code{\link{child_hcc}},
\code{\link{infant_demo}}
}
\concept{factors}
\keyword{datasets}
