% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filing_details.R
\name{filing_details}
\alias{filing_details}
\alias{filing_details.character}
\alias{filing_details.xml_node}
\title{SEC Filing Details}
\usage{
filing_details(x)

\method{filing_details}{character}(x)

\method{filing_details}{xml_node}(x)
}
\arguments{
\item{x}{URL to a SEC filing index page}
}
\value{
A list with the following components:
  \describe{
    \item{information}{A data.frame as returned by \code{\link{filing_information}}}
    \item{documents}{A data.frame as returned by \code{\link{filing_documents}}}
    \item{filers}{A data.frame as returned by \code{\link{filing_filers}}}
    \item{funds}{A data.frame as returned by \code{\link{filing_funds}}}
 }
}
\description{
The SEC generates a html page as an index for every filing it receives containing
all the meta-information about the filing. We extract 3 main types of information:
\describe{
 \item{Filing Information}{Filing date, accepted date, etc.}
 \item{Documents}{All the documents included in the filing}
 \item{Filers}{Companies included in the filing}
 \item{Funds}{Funds included in the filing}
}
}
\details{
For a company, there is typically a single filer and no funds, but many filings
for funds get more complicated - e.g. 400+ funds with 100's of companies

NOTE: This can get process intensive for large fund pages. If you don't need all
components, try just using filing_info
}
\examples{
\donttest{
# Typically you'd get the URL from one of the search functions
x <- paste0("https://www.sec.gov/Archives/edgar/data/",
            "712515/000071251517000063/0000712515-17-000063-index.htm")
filing_details(x)
}
}
