% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eddi.R
\name{get_eddi}
\alias{get_eddi}
\title{Get EDDI data}
\usage{
get_eddi(date, timescale, dir = tempdir(), overwrite = FALSE)
}
\arguments{
\item{date}{An object of class Date or a character string formatted as
%Y-%m-%d (e.g., "2016-04-01") which specifies the date(s) for which data
are to be acquired. To specify a time interval or date range, date can be
a vector of class Date such as produced by \code{seq.Date}.}

\item{timescale}{A string that specifies the timescale for EDDI, e.g.,
"1 week", "12 month". The \code{get_eddi} function assumes that a space
separates the number for the timescale (e.g., "1", "12") from the units
(e.g., "week", "month"). Fractional timescales are not supported, and will
be rounded to the nearest integer (e.g., "1.1 week" will be converted to
"1 week").}

\item{dir}{Directory to for downloaded EDDI data. By default this will be
a temporary directory. This should be a file path specified as a string.}

\item{overwrite}{Boolean to indicate whether to overwrite EDDI data that
already exist locally in \code{dir}. Defaults to FALSE.}
}
\value{
A Raster* object containing EDDI data. Each layer in this object
corresponds to data for one date.
}
\description{
This function searches for EDDI data on a specific date, returning a
\code{Raster*} object.
}
\details{
The Evaporative Demand Drought Index is available for each day from 1980 to
present, usually with a ~5 day lag to the current date. It is available at
multiple timescales, including the 1 to 12 week and 1 to 12 months scales.
For more information see \url{https://www.esrl.noaa.gov/psd/eddi/}
}
\examples{
\donttest{
# note that downloads may take a while, depending on internet connection
get_eddi(date = "2018-01-01", timescale = "1 month")
}

}
