% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackedsdm_s3.R
\name{predict.stackedsdm}
\alias{predict.stackedsdm}
\title{Predictions from a stackedsdm object}
\usage{
\method{predict}{stackedsdm}(
  object,
  newdata = NULL,
  type = "link",
  se.fit = FALSE,
  na.action = na.pass,
  ...
)
}
\arguments{
\item{object}{An object of class \code{stackedsdm}}

\item{newdata}{Pptionally, a data frame in which to look for variables with which to predict.  If omitted, the covariates from the existing dataset are used.}

\item{type}{The type of prediction required.  This can be supplied as either a single character string, when is applied to all species, or a vector of character strings of the same length as \code{ncol(object$y)} specifying the type of predictions desired for each species. The exact type of prediction allowed depends precisely on the distribution, but for many there is at least `"link"' which is on the scale of the linear predictors, and ‘"response"’ which is on the scale of the response variable. The values of this argument can be abbreviated.}

\item{se.fit}{Logical switch indicating if standard errors are required.}

\item{na.action}{Function determining what should be done with missing values in '"newdata"'. The default is to predict \code{NA}..}

\item{...}{not used}
}
\value{
A list where the k-th element is the result of applying the \code{predict} method to the k-th fitted model in \code{object$fits}.
}
\description{
Predictions from a stackedsdm object
}
\section{Details}{

 This function simply applies a for loop, cycling through each fitted model from the \code{stackedsdm} object and then attempting to construct the relevant predictions by applying the relevant \code{predict} method. Please keep in mind no formatting is done to the predictions.
}

\section{Author(s)}{

Francis K.C. Hui <francis.hui@anu.edu.au>.
}

\examples{
X <- as.data.frame(spider$x)
abund <- spider$abund

# Example 1: Simple example
myfamily <- "negative.binomial"
# Fit models including all covariates are linear terms, but exclude for bare sand
fit0 <- stackedsdm(abund, formula_X = ~. -bare.sand, data = X, family = myfamily, ncores=2) 
predict(fit0, type = "response")

\donttest{
# Example 2: Funkier example where Species are assumed to have different distributions
abund[,1:3] <- (abund[,1:3]>0)*1 # First three columns for presence absence
myfamily <- c(rep(c("binomial"), 3),
       rep(c("negative.binomial"), 5),
       rep(c("tweedie"), 4)
       )
fit0 <- stackedsdm(abund, formula_X = ~ bare.sand, data = X, family = myfamily, ncores=2)
predict(fit0, type = "response")
}
}
