% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_delete.R
\name{wf_delete}
\alias{wf_delete}
\title{ECMWF delete request}
\usage{
wf_delete(url, user, service = "webapi", verbose = TRUE)
}
\arguments{
\item{url}{url to query}

\item{user}{user (email address) used to sign up for the ECMWF data service,
used to retrieve the token set by \code{\link[ecmwfr]{wf_set_key}}}

\item{service}{character, one of \code{ecmwf} or \code{cds} depending
on the data set to be deleted.}

\item{verbose}{show feedback on processing}
}
\description{
Deletes a staged download from the queue
}
\examples{

\dontrun{
# set key
wf_set_key(email = "test@mail.com", key = "123")

# get key
wf_get_key(email = "test@mail.com")
}
}
\seealso{
\code{\link[ecmwfr]{wf_set_key}}
\code{\link[ecmwfr]{wf_transfer}}
\code{\link[ecmwfr]{wf_request}}
}
\author{
Koen Kufkens
}
\keyword{climate,}
\keyword{data}
\keyword{download,}
\keyword{re-analysis}
