% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{downloadDMRs}
\alias{downloadDMRs}
\title{Download Multiple DMRs}
\usage{
downloadDMRs(df, idColumn, pBar = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{df}{dataframe with column of id numbers}

\item{idColumn}{unquoted string, name of column containing the p_id permit numbers}

\item{pBar}{logical, display a progress bar? Defaults to TRUE}

\item{verbose}{logical, indicating whether to provide processing and retrieval messages. Defaults to FALSE. Suggest leaving this FALSE if \code{pBar = TRUE}.}

\item{...}{additional arguments passed to echoGetEffluent}
}
\value{
dataframe df, with a column containing the discharge monitoring reports downloaded with echoGetEffluentSummary
}
\description{
Returns DMRs in a nested list using \code{echoGetEffluent()}. Uses a dataframe with a column of p_id numbers. Please note that p_id's are case sensitive.
}
\examples{
\donttest{
## This example requires an internet connection to run

## Retrieve multiple DMRs for flow

df <- tibble::tibble("id" = c('TX0119407', 'TX0132187', 'TX040237'))
df <- downloadDMRs(df, id)
}
}
