% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{legend_action}
\alias{legend_action}
\alias{e_legend_select}
\alias{e_legend_unselect}
\alias{e_legend_toggle_select}
\alias{e_legend_scroll}
\title{Legend}
\usage{
e_legend_select(e, name, btn = NULL)

e_legend_unselect(e, name, btn = NULL)

e_legend_toggle_select(e, name, btn = NULL)

e_legend_scroll(e, scroll_index = NULL, legend_id = NULL, btn = NULL)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{name}{Legend name.}

\item{btn}{A \code{\link{e_button}} id.}

\item{scroll_index}{Controle the scrolling of legend when \code{type = "scroll"} in \code{e_legend}.}

\item{legend_id}{Id of legend.}
}
\description{
Legend
}
\examples{
e <- CO2 \%>\% 
  group_by(Type) \%>\% 
  e_charts(conc) \%>\% 
  e_scatter(uptake) 
  
e \%>\% 
  e_legend_unselect("Quebec")
  
e \%>\% 
  e_legend_unselect("Quebec", btn = "btn") \%>\% 
  e_button("btn", "Quebec")

}
