% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-qsl-fit-plot-method.R
\name{lamp.qsl_fit_plot}
\alias{lamp.qsl_fit_plot}
\title{Plot the fit to asset returns using quartic stable lambda distribution}
\usage{
lamp.qsl_fit_plot(
  key,
  debug = FALSE,
  plot.type = c("pdf", "log-pdf"),
  qqplot.n = 1e+06,
  extdata_dir = NULL,
  filename = NULL
)
}
\arguments{
\item{key}{character, the key(s) to retrieve configuration for plot.
If key is provided as single-row data frame, then it will be used directly as config.}

\item{debug}{logical, if true, print debug information. Default is FALSE.}

\item{plot.type}{character, type of plot: pdf, log-pdf, qqplot. Default is \code{c("pdf","log-pdf")}.}

\item{qqplot.n}{numeric, specify number of QSLD simulations for qqplot utility, default is 1000000.}

\item{extdata_dir}{optionally specify user's own extdata folder, default is NULL.}

\item{filename}{character, optionally specify user's own config file name, default is NULL.}
}
\value{
returns a list of each key and its data and config blocks as nested list
}
\description{
Plot the fit to asset returns using quartic stable lambda distribution
}
\author{
Stephen H-T. Lihn
}
\keyword{QSLD}
