% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_example_layer.R
\name{gen_example}
\alias{gen_example}
\title{Generate vegetation example}
\usage{
gen_example(
  n = 300,
  use_layer = TRUE,
  height_max = 20,
  ly_list = "",
  st_list = LETTERS[1:9],
  sp_list = letters[1:9],
  st_group = NULL,
  sp_group = NULL,
  cover_list = 2^(0:6)
)
}
\arguments{
\item{n}{A numeric to generate no of occurrences.}

\item{use_layer}{A logical. If FALSE, height_max and ly_list
will be omitted.}

\item{height_max}{A numeric. The highest layer of samples.}

\item{ly_list, st_list, sp_list, st_group, sp_group}{A string vector.
st_group and sp_group are optional (default is NULL).
Length of st_list and sp_list should be the same
as st_group and sp_group, respectively.}

\item{cover_list}{A numeric vector.}
}
\value{
A dataframe with columns: stand, layer, species, cover,
st_group and sp_group.
}
\description{
Stand, species, and cover are basic.
Layer, height, st_group, are sp_group optional.
}
\examples{
n <- 300
height_max <- 20
ly_list    <- c("B1", "B2", "S1", "S2", "K")
st_list    <- LETTERS[1:9]
sp_list    <- letters[1:9]
st_group   <- rep(LETTERS[24:26], 3)
sp_group   <- rep(letters[24:26], 3)
cover_list <- 2^(0:6)
gen_example(n = n, use_layer = TRUE,
            height_max = height_max, ly_list = ly_list, 
            st_list  = st_list,  sp_list  = sp_list,
            st_group = st_group, sp_group = sp_group,
            cover_list = cover_list)

}
