% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-mapping.R
\name{calc_full_extent}
\alias{calc_full_extent}
\title{Calculate the spatial extent of non-zero data in a raster}
\usage{
calc_full_extent(x, aggregate = TRUE)
}
\arguments{
\item{x}{\code{Raster} object; either a full 52-week data cube or a subset.}

\item{aggregate}{logical; whether data should be aggregated by a factor of 3
in each dimension prior to calculating the extent. When working with the
high resolution cubes, data should be aggregated otherwise processing times
will be extremely long.}
}
\value{
The extent of occurrence as a \code{raster} \link{Extent} object.
}
\description{
eBird Status and Trends data cubes are defined over broad areas, filling in
regions where the species doesn't occur with zeros (predicted absences) or
NAs (regions where models weren't fit). When producing maps, it's best to
only display the spatial extent where the species occurs. To show determine
an ideal extent for mapping, this function trims away 0 and NA values. When
called on a \code{RasterStack} (e.g., a data cube consisting of all 52 weeks),
this function returns the extent of occurrence across all layers.To access a
pre-calculated extent for the full annual cycle use
\code{\link[=load_fac_map_parameters]{load_fac_map_parameters()}}.
}
\examples{
\dontrun{
# simple toy example
r <- raster::raster(nrow = 100, ncol = 100)
r[5025:5075] <- 1
raster::extent(r)
calc_full_extent(r)

# download example data
path <- ebirdst_download("example_data")
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# load abundance data
abd <- load_raster(path, "abundance")

# calculate full extent
map_extent <- calc_full_extent(abd)

# plot
raster::plot(abd[[20]], axes = FALSE, ext = map_extent)
}
}
