% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemCategoryMinMax.R
\name{itemCategoryRange}
\alias{itemCategoryRange}
\alias{itemCategoryMin}
\alias{itemCategoryMax}
\alias{itemCategoryDeviation}
\title{Create item category constraints with minimum and maximum.}
\usage{
itemCategoryRange(nForms, nItems, itemCategories, range)

itemCategoryMin(nForms, nItems, itemCategories, min)

itemCategoryMax(nForms, nItems, itemCategories, max)

itemCategoryDeviation(
  nForms,
  nItems,
  itemCategories,
  targetValues,
  allowedDeviation,
  relative = FALSE
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{nItems}{Number of items in the item pool.}

\item{itemCategories}{a factor representing the categories/grouping of the items}

\item{range}{a matrix with two columns representing the the minimal and the
maximum frequency of the items from each level/category \code{itemCategories}}

\item{min}{the minimal sum of the \code{itemValues} per test form}

\item{max}{the minimal sum of the \code{itemValues} per test form}

\item{targetValues}{an integer vector representing the target number per category.
The order of the target values should correspond with the order of the levels
of the factor in \code{itemCategory}.}

\item{allowedDeviation}{the maximum allowed deviation from the \code{targetValue}}

\item{relative}{a logical expressing whether or not the \code{allowedDeviation}
should be interpreted as a proportion of the \code{targetValue}}
}
\value{
A sparse matrix.
}
\description{
\code{itemCategoriesRange}, \code{itemCategoriesMin}, and \code{itemCategoriesMax}
create constraints related to item categories/groupings (as
represented by \code{itemCategories}). That is, the created
constraints assure that the number of items of each category per test form is either
smaller or equal than the specified \code{max}, greater than or equal to \code{min}
or both \code{range}.
}
\details{
\code{itemCategoriesDeviation} also constrains the minimal and the maximal value
of the number of items of each category per test form, but based on chosen
\code{targetValues}, and maximal allowed deviations (i.e., \code{allowedDeviation})
from those \code{targetValues}.
}
\section{Functions}{
\itemize{
\item \code{itemCategoryMin}: constrain minimum value

\item \code{itemCategoryMax}: constrain maximum value

\item \code{itemCategoryDeviation}: constrain the distance form the \code{targetValues}
}}

\examples{
## constraints to make sure that there are at least 2 and maximally 4
##  items of each item type in each test form
nItems <- 30
item_type <- factor(sample(1:3, size = nItems, replace = TRUE))
itemCategoryRange(2, nItems, item_type, range = cbind(min = rep(2, 3), range = rep(4, 3)))

## or alternatively
itemCategoryDeviation(2, nItems, item_type, targetValues = rep(3, 3), allowedDeviation = rep(4, 3))

}
