% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{integrateRegCurve}
\alias{integrateRegCurve}
\title{Integrate the area over/under the regularization path of a penalized regression model}
\usage{
integrateRegCurve(fit, weighted = FALSE)
}
\arguments{
\item{fit}{A regularized regression model fited using glmnet}

\item{weighted}{Should the regularization curve be weighted by the corresponding lambda (as higher lambda pushes coefficients to zero)}
}
\value{
Integrated area over or under a regularization curve using the trapezoid method from the pracma-package
}
\description{
This function evaluates the overall significance of a regularized regression coefficient in a penalized Cox model. It takes into account the whole range of lambda-penalization parameter, and computes the area over or under the regularization curve. This gives more insight into the importance of a regression coefficient over the whole range of lambda, instead of evaluating it at a single optimal lambda point determined typically using cross-validation.
}
\examples{
# Exemplify one PSP of the readily fitted ensembles
data(ePCRmodels)
RegAUC <- cbind(
integrateRegCurve(fit = DREAM@PSPs[[1]]@fit),
integrateRegCurve(fit = DREAM@PSPs[[2]]@fit),
integrateRegCurve(fit = DREAM@PSPs[[3]]@fit)
)
SortRegAUC <- RegAUC[order(apply(RegAUC, MARGIN=1, 
	FUN=function(z) abs(mean(z)) ), decreasing=TRUE),]
colnames(SortRegAUC) <- c(DREAM@PSPs[[1]]@description, 
DREAM@PSPs[[2]]@description,
DREAM@PSPs[[3]]@description)
SortRegAUC[1:10,] # Top 10 coefficients according to (absolute) regularization curve auc
}
