% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survCurv.R
\name{survDiff}
\alias{survDiff}
\title{Estimated Difference Between Survival or Cumulative Hazard Functions}
\usage{
survDiff(object, newdata, type = c("survival", "cumhaz"),
         level = 0.95, cache = FALSE, ...)
}
\arguments{
\item{object}{An object returned by function \code{bayesCox}.}

\item{newdata}{An optional data frame used to generate a design matrix.
Note that it must lead to a design matrix with two different design.}

\item{type}{An optional character value indicating the type of function to
compute. The possible values are "survival" and "cumhaz". The former
means the estimated survival function; the latter represents the
estimated cumulative hazard function for the given \code{newdata}.}

\item{level}{A numerical value between 0 and 1 indicating the level of
cradible band.}

\item{cache}{A logical value. If \code{TRUE}, the cache RData file will be
generated in the working directory to improve the performance of
function \code{survCurve} and \code{survDiff}. This option would be
quite helpful if the number of MCMC sample is large.}

\item{...}{Other arguments for further usage.}
}
\value{
A data frame with column: "Low", "Mid", "High", "Time", "Design",
    and "type", and attribute, "surv" valued as "survDiff".
}
\description{
\code{survDiff} returns estimated suvival function or cumulative function
from posterior estimates. Note that currently, the function is only
applicable to the Bayesian dynamic Cox model with dynamic hazard, where the
control argument is specified to be \code{control = list(intercept = TRUE)}
in function \code{bayesCox}.
}
\details{
The estimated difference between survival curves is a step function
representing the difference between the posterior mean survival proportion
at the given time grid from the posterior sample.  Its credible interval is
constructed based on the quantiles of all the pair difference between the
survival curves from posterior sample at given credible level.
}
\examples{

## See the examples in bayesCox.

}
\seealso{
\code{\link{bayesCox}}, \code{\link{survCurve}}, and
\code{\link{plotSurv}}.
}

