% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrPredict.R
\name{predict.dynrModel}
\alias{predict.dynrModel}
\title{\code{predict} method for \code{dynrModel} objects}
\usage{
\method{predict}{dynrModel}(object, newdata = NULL, interval = c("none",
  "confidence", "prediction"), method = c("kalman", "ensemble"),
  level = 0.95, type = c("latent", "observed"), ...)
}
\arguments{
\item{object}{a dynrModel object from which predictions are desired}

\item{newdata}{an optional \code{data.frame} or \code{ts} object. See details.}

\item{interval}{character indicating what kind of intervals are desired.  'none' gives no intervals, 'confidence', gives confidence intervals, 'prediction' gives prediction intervals.}

\item{method}{character the method used to create the forecasts.  See details.}

\item{level}{the confidence or predictions level, ignored if not using intervals}

\item{type}{character the type of thing you want predicted: latent variables or manifest variables.}

\item{...}{further named arguments, e.g., \code{size} for the ensemble size when using the ensemble prediction}
}
\value{
A list of the prediction estimates, intervals, and ensemble members.
}
\description{
\code{predict} method for \code{dynrModel} objects
}
\details{
The \code{newdata} argument is either a \code{data.frame} or \code{ts} object.  It passed as the \code{dataframe} argument of \code{dynr.data} and must accept the same further arguments as the data in the model passed in the \code{object} argument (e.g., same \code{id}, \code{time}, \code{observed}, and \code{covariates} arguments).

The available methods for prediction are 'kalman' and 'ensemble'.  The 'kalman' method uses the Kalman filter to create predictions.  The 'ensemble' method simulates a set of initial conditions and lets those run forward in time.  The distribution of this ensemble provides the predictions.  The mean is the value predicted.  The quantiles of the distribution provide the intervals.
}

