% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamite-package.R
\docType{data}
\name{latent_factor_example_fit}
\alias{latent_factor_example_fit}
\title{Model Fit for the Simulated Latent Factor Data}
\format{
A \code{dynamitefit} object.
}
\source{
Script in
\url{https://github.com/ropensci/dynamite/blob/main/data-raw/latent_factor_example_fit.R}
}
\usage{
latent_factor_example_fit
}
\description{
A \code{dynamitefit} object obtained by running \code{dynamite} on the
\code{latent_factor_example} dataset as
\preformatted{
set.seed(1)
library(dynamite)
latent_factor_example_fit <- dynamite(
  obs(y ~ 1, family = "gaussian") + lfactor() + splines(df = 10),
  data = latent_factor_example,
  group = "id",
  time = "time",
  iter = 2000,
  warmup = 1000,
  thin = 10,
  chains = 2,
  cores = 2,
  refresh = 0,
  save_warmup = FALSE,
  pars = c("omega_alpha_1_y", "omega_raw_alpha_y", "omega_raw_psi", "L_lf",
    "lambda_raw_y", "lambda_std_y"),
  include = FALSE
)
}
Note the very small number of samples due to size restrictions on CRAN.
}
\keyword{datasets}
