% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_design_matrix.R
\name{ddFixed}
\alias{ddFixed}
\alias{ddFixed_intercept}
\title{Auxiliary Functions for Fixed Effects}
\usage{
ddFixed(object)

ddFixed_intercept(object)
}
\arguments{
\item{object}{expression that would be used in formula. E.g. \code{x} or \code{poly(x, degree = 3)}.}
}
\description{
Functions used in formula of \code{\link{ddhazard}} for time-invariant effects. \code{ddFixed_intercept} is only used for the intercept.
}
\examples{
# we can get a time-invariant effect of `x1` by
\dontrun{
ddhazard(Surv(stop, event) ~ ddFixed(x1), data)
}

# all of the calls below will yield the same result with a time-invariant
# intercept:
\dontrun{
ddhazard(Surv(stop, event) ~ ddFixed_intercept() + x1, data)
ddhazard(Surv(stop, event) ~ -1 + ddFixed_intercept() + x1, data)
ddhazard(Surv(stop, event) ~ ddFixed_intercept(what_ever) + x1, data)
}
}
