/*
 * Decompiled with CFR 0.152.
 */
package drawing;

import don.DonneeID;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.annotations.XYIDAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.plot.XYPlot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Canvas {
    private Vector<XYIDAnnotation> m_annot = new Vector();
    private Vector<XYLineAnnotation> m_branche = new Vector();
    private Vector<DonneeID> m_point = new Vector();

    public void clearBranche() {
        this.m_branche.clear();
    }

    public void addBranche(XYLineAnnotation branche) {
        this.m_branche.add(branche);
    }

    public XYLineAnnotation getBranche(int i) {
        return this.m_branche.get(i);
    }

    public int tailleBranche() {
        return this.m_branche.size();
    }

    public Vector<XYIDAnnotation> getVectAnnot() {
        return this.m_annot;
    }

    public void setVectAnnot(Vector<XYIDAnnotation> annot) {
        this.m_annot = annot;
    }

    public XYIDAnnotation getAnnot(int i) {
        return this.m_annot.get(i);
    }

    public int indexOfAnnot(XYIDAnnotation annot) {
        return this.m_annot.indexOf(annot);
    }

    public void remplaceAnnot(XYIDAnnotation nouvelle, int destinationIndex) {
        this.m_annot.setElementAt(nouvelle, destinationIndex);
    }

    public void rmAnnot(int index) {
        this.m_annot.remove(index);
    }

    public void rmAnnot(XYIDAnnotation annot) {
        this.m_annot.remove(annot);
    }

    public void clearAnnot() {
        this.m_annot.clear();
    }

    public int tailleAnnot() {
        return this.m_annot.size();
    }

    public void addAnnot(XYIDAnnotation annot) {
        this.m_annot.add(annot);
    }

    public void addPoint(DonneeID point) {
        this.m_point.add(point);
    }

    public void setPoint(Vector<DonneeID> point) {
        this.m_point = point;
    }

    public DonneeID getPoint(int i) {
        return this.m_point.get(i);
    }

    public void clearPoint() {
        this.m_point.clear();
    }

    public Vector<DonneeID> getPoint() {
        return this.m_point;
    }

    public int taillePoint() {
        return this.m_point.size();
    }

    public XYIDAnnotation findAnnot(ChartPanel f, Point2D pointChart) {
        int i = 0;
        double x = pointChart.getX();
        double y = pointChart.getY();
        while (i < this.tailleAnnot()) {
            XYIDAnnotation annot = this.getAnnot(i);
            double xa = Canvas.chartToJava2D(f, annot.getX(), true);
            double ya = Canvas.chartToJava2D(f, annot.getY(), false);
            Rectangle2D s = (Rectangle2D)annot.getBounds((Graphics2D)f.getGraphics());
            double minlblx = xa + s.getX() - 0.5 * s.getWidth();
            double maxlblx = xa + s.getX() + 0.5 * s.getWidth();
            double minlbly = ya + s.getY();
            double maxlbly = ya + s.getY() + s.getHeight();
            if (x >= minlblx && x <= maxlblx && y >= minlbly && y <= maxlbly) {
                return annot;
            }
            ++i;
        }
        return null;
    }

    public Vector<DonneeID> findPoint(ChartPanel f, Rectangle2D rec) {
        double minlblx = Canvas.java2Dtochart(f, rec.getX(), true);
        double maxlblx = Canvas.java2Dtochart(f, rec.getX() + rec.getWidth(), true);
        double maxlbly = Canvas.java2Dtochart(f, rec.getY(), false);
        double minlbly = Canvas.java2Dtochart(f, rec.getY() + rec.getHeight(), false);
        Vector<DonneeID> save = new Vector<DonneeID>();
        int i = 0;
        while (i < this.taillePoint()) {
            double x = this.getPoint(i).getCoord(f.getGestionnaire().getAxeX());
            double y = this.getPoint(i).getCoord(f.getGestionnaire().getAxeY());
            if (x >= minlblx && x <= maxlblx && y >= minlbly && y <= maxlbly) {
                save.add(this.getPoint(i));
            }
            ++i;
        }
        return save;
    }

    public boolean contientX(ChartPanel f, Rectangle2D rectJava, double Xchart) {
        double minlblx = Canvas.java2Dtochart(f, rectJava.getX(), true);
        double maxlblx = Canvas.java2Dtochart(f, rectJava.getX() + rectJava.getWidth(), true);
        return Xchart >= minlblx && Xchart <= maxlblx;
    }

    public boolean bordVertical(ChartPanel f, Rectangle2D rectJava) {
        ChartRenderingInfo info = f.getChartRenderingInfo();
        Rectangle2D dataArea = info.getPlotInfo().getDataArea();
        double bord_gauche = dataArea.getX();
        double bord_droit = bord_gauche + dataArea.getWidth();
        double rect_gauche = rectJava.getX();
        double rect_droite = rect_gauche + rectJava.getWidth();
        if (bord_gauche >= rect_gauche && bord_gauche <= rect_droite) {
            return true;
        }
        return bord_droit >= rect_gauche && bord_droit <= rect_droite;
    }

    public boolean bordHorizontal(ChartPanel f, Rectangle2D rectJava) {
        ChartRenderingInfo info = f.getChartRenderingInfo();
        Rectangle2D dataArea = info.getPlotInfo().getDataArea();
        double bord_haut = dataArea.getY();
        double bord_bas = bord_haut + dataArea.getHeight();
        double rect_haut = rectJava.getY();
        double rect_bas = rect_haut + rectJava.getHeight();
        if (bord_haut >= rect_haut && bord_haut <= rect_bas) {
            return true;
        }
        return bord_bas >= rect_haut && bord_bas <= rect_bas;
    }

    public boolean contientY(ChartPanel f, Rectangle2D rectJava, double Ychart) {
        double maxlbly = Canvas.java2Dtochart(f, rectJava.getY(), false);
        double minlbly = Canvas.java2Dtochart(f, rectJava.getY() + rectJava.getHeight(), false);
        return Ychart >= minlbly && Ychart <= maxlbly;
    }

    public static double java2Dtochart(ChartPanel f, double val, boolean isX) {
        XYPlot plot = (XYPlot)f.getChart().getPlot();
        ChartRenderingInfo info = f.getChartRenderingInfo();
        Rectangle2D dataArea = info.getPlotInfo().getDataArea();
        if (isX) {
            return plot.getDomainAxis().java2DToValue(val, dataArea, plot.getDomainAxisEdge());
        }
        return plot.getRangeAxis().java2DToValue(val, dataArea, plot.getRangeAxisEdge());
    }

    public static double chartToJava2D(ChartPanel f, double val, boolean isX) {
        XYPlot plot = (XYPlot)f.getChart().getPlot();
        ChartRenderingInfo info = f.getChartRenderingInfo();
        Rectangle2D dataArea = info.getPlotInfo().getDataArea();
        if (isX) {
            return plot.getDomainAxis().valueToJava2D(val, dataArea, plot.getDomainAxisEdge());
        }
        return plot.getRangeAxis().valueToJava2D(val, dataArea, plot.getRangeAxisEdge());
    }
}

