/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Continue;
import don.DonneeID;
import don.Groupe;
import don.Individu;
import don.Modalite;
import don.QualifiableRepresentable;
import don.Variable;
import exceptions.ExceptionIntegrite;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinueAnalysee
extends QualifiableRepresentable
implements Variable,
Continue {
    private static final long serialVersionUID = 1719739952929130158L;
    private boolean m_orthonorme;
    private int num = -1;

    public ContinueAnalysee(String annotation, boolean active, Groupe gr, double[] coord, double[] cos2, double[] contrib, boolean orthonorme) {
        super(annotation, active, gr, coord, cos2, contrib, 0);
        this.m_orthonorme = orthonorme;
    }

    public boolean isOrthonorme() {
        return this.m_orthonorme;
    }

    public void setOrthonorme(boolean orthonorme) {
        this.m_orthonorme = orthonorme;
    }

    public String getNom() {
        return this.getAnnotation();
    }

    @Override
    public double getMin(Vector<? extends DonneeID> vect) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < vect.size()) {
            double res = this.getValeur(vect.get(i));
            if (res < min) {
                min = res;
            }
            ++i;
        }
        return min;
    }

    public double getMax(Vector<? extends DonneeID> vect) {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < vect.size()) {
            double res = this.getValeur(vect.get(i));
            if (res > max) {
                max = res;
            }
            ++i;
        }
        return max;
    }

    @Override
    public double getValeur(DonneeID donneeID) {
        if (donneeID instanceof Individu) {
            return this.getValeur((Individu)donneeID);
        }
        if (donneeID instanceof Modalite) {
            return ((Modalite)donneeID).getValeur(this);
        }
        return 0.0;
    }

    @Override
    public double getAmplitude(Vector<? extends DonneeID> vect) {
        return this.getMax(vect) - this.getMin(vect);
    }

    @Override
    public Double getValeurAbsolueMax(Vector<? extends DonneeID> donnees) {
        return Math.max(this.getMax(donnees), -this.getMin(donnees));
    }

    public double getValeur(Individu ind) {
        return ind.getValeur(this.num);
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    @Override
    public void verifierIntegrite() throws ExceptionIntegrite {
        super.verifierIntegrite();
        if (this.num == -1) {
            throw new ExceptionIntegrite("Variable sans num\u00e9ro, impossible d'effectuer des getValeur");
        }
        if (this.num == 0) {
            throw new ExceptionIntegrite("Variable sans num\u00e9ro, impossible d'effectuer des getValeur");
        }
    }
}

