% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{exclude}
\alias{exclude}
\title{Remove Particular Names from a Longer List}
\usage{
exclude(what, from = mod_standard)
}
\arguments{
\item{what}{vector of distribution names to exclude}

\item{from}{vector of distribution names to be excluded from}
}
\value{
vector of names from "from" after excluding "what"
}
\description{
Removes specific values (\code{what}) from a longer vector of values (\code{from}).
By default, \code{from = mod_standard}, and the intent is to simplify the
subsetting of \code{ddArray} objects created with the default standard models.
For example, \code{dmod2 <- dmod[exclude("lognormal")]} would subset the list
of models in \code{mod_standard} to exclude \code{"lognomal"}. The default can
be overridden by providing a specific vector for \code{from} (for example,
\code{dmod[exclude("lognormal", from = names(dmod)])}).
}
