% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_2t_unequal.R
\name{power_2t_unequal}
\alias{power_2t_unequal}
\title{Calculate Power for Two-Sample Unequal Variance T-Test}
\usage{
power_2t_unequal(n = 100, d, sigsq1, sigsq2, alpha = 0.05)
}
\arguments{
\item{n}{Numeric value specifying per-group sample size.}

\item{d}{Numeric value specifying true difference in group means. Should be
positive.}

\item{sigsq1, sigsq2}{Numeric value specifying the variance of observations in
each group.}

\item{alpha}{Numeric value specifying type-1 error rate.}
}
\value{
Numeric value.
}
\description{
Unequal variance version of \code{\link{power_2t_equal}}. Assumes an equal
sample size for both groups, which is actually not optimal.
}
\examples{
# Power to detect difference of 0.2 with 100 subjects per group and sigsq's
# of 1 and 1.25
power_2t_unequal(n = 100, d = 0.2, sigsq1 = 1, sigsq2 = 1.25)

}
