# Generated by 02-duckplyr_df-methods.R
#' @export
slice.duckplyr_df <- function(.data, ..., .by = NULL, .preserve = FALSE) {
  # Our implementation
  rel_try(
    "No relational implementation for slice()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  slice <- dplyr$slice.data.frame
  out <- slice(.data, ..., .by = {{ .by }}, .preserve = .preserve)
  return(out)

  # dplyr implementation
  check_dots_unnamed()

  dots <- enquos(...)

  by <- compute_by(
    by = {{ .by }},
    data = .data,
    by_arg = the$slice_by_arg,
    data_arg = ".data"
  )

  loc <- slice_rows(.data, dots, by)
  dplyr_row_slice(.data, loc, preserve = .preserve)
}

duckplyr_slice <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- slice(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
