% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtw2.R
\name{dtw2}
\alias{dtw2}
\title{DTW distance with L2 norm}
\usage{
dtw2(x, y, ...)
}
\arguments{
\item{x, y}{A time series. A multivariate series should have time spanning the rows and variables
spanning the columns.}

\item{...}{Further arguments for \code{\link[dtw:dtw]{dtw::dtw()}}.}
}
\value{
An object of class \code{dtw}.
}
\description{
Wrapper for the \code{\link[dtw:dtw]{dtw::dtw()}} function using L2 norm for both the local cost matrix (LCM) creation
as well as the final cost aggregation step.
}
\details{
The L-norms are used in two different steps by the DTW algorithm. First when creating the LCM,
where the element \eqn{(i,j)} of the matrix is computed as the L-norm of \eqn{x^v_i - y^v_j} for
all variables \eqn{v}. Note that this means that, in case of multivariate series, they must have
the same number of variables, and that univariate series will produce the same LCM regardless of
the L-norm used. After the warping path is found by DTW, the final distance is calculated as the
L-norm of all \eqn{(i,j)} elements of the LCM that fall on the warping path.

The \code{\link[dtw:dtw]{dtw::dtw()}} function allows changing the norm by means of its \code{dist.method} parameter, but
it only uses it when creating the LCM, and not when calculating the final aggregated cost, i.e.
the DTW distance.

This wrapper simply returns the appropriate DTW distance using L2 norm (Euclidean norm). A
\code{\link[proxy:dist]{proxy::dist()}} version is also registered.

The windowing constraint uses a centered window. The calculations expect a value in
\code{window.size} that represents the distance between the point considered and one of the edges
of the window. Therefore, if, for example, \code{window.size = 10}, the warping for an
observation \eqn{x_i} considers the points between \eqn{x_{i-10}} and \eqn{x_{i+10}}, resulting
in \code{10(2) + 1 = 21} observations falling within the window.
}
