% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-dtwclust.R
\name{create_dtwclust}
\alias{create_dtwclust}
\title{Create formal \code{dtwclust} objects}
\usage{
create_dtwclust(..., override.family = TRUE)
}
\arguments{
\item{...}{Any valid slots of \code{\link{dtwclust-class}}.}

\item{override.family}{Attempt to substitute the default family with one that conforms to the
provided elements? See details.}
}
\value{
A \code{\link{dtwclust-class}} object.
}
\description{
Helper function to manually create formal \code{\link{dtwclust-class}} objects
}
\details{
This function can calculate some of the slots if certain elements are provided by the user. In
order to get a fully functional object at least the following slots should be provided:

\itemize{
  \item \code{type}: "partitional", "hierarchical", "fuzzy" or "tadpole".
  \item \code{datalist}: The data in one of the supported formats.
  \item \code{centroids}: The time series centroids in one of the supported formats.
  \item \code{cluster}: The cluster indices for each series in the \code{datalist}.
  \item \code{control*}: A \code{dtwclustControl} object (or a named list) with the desired
    parameters.
  \item \code{distance*}: A string indicating the distance that should be used.
  \item \code{centroid*}: A string indicating the centroid to use (only necessary for partitional
    clustering).
}

*Necessary when overriding the default family for the calculation of other slots, CVIs or
prediction. Maybe not always needed, e.g. for plotting.
}
\examples{

data(uciCT)

# Assuming this was generated by some clustering procedure
centroids <- CharTraj[seq(1L, 100L, 5L)]
control <- new("dtwclustControl", window.size = 8L, norm = "L2")
cluster <- unclass(CharTrajLabels)

pc_obj <- create_dtwclust(type = "partitional", datalist = CharTraj, centroids = centroids,
                          control = control, cluster = cluster,
                          distance = "sbd", centroid = "dba",
                          dots = list(step.pattern = symmetric1))

fc_obj <- create_dtwclust(type = "fuzzy", datalist = CharTraj, centroids = centroids,
                          control = control, cluster = cluster,
                          distance = "sbd", centroid = "fcm")

fc_obj

}

