% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInternals.R
\docType{methods}
\name{get}
\alias{get}
\alias{getAlignments,twdtwMatches-method}
\alias{getAlignments}
\alias{getInternals,twdtwMatches-method}
\alias{getInternals}
\alias{getMatches,twdtwMatches-method}
\alias{getMatches}
\title{Get elements from twdtwMatches objects}
\usage{
\S4method{getAlignments}{twdtwMatches}(object, timeseries.labels = NULL,
  patterns.labels = NULL)

\S4method{getInternals}{twdtwMatches}(object, timeseries.labels = NULL,
  patterns.labels = NULL)

\S4method{getMatches}{twdtwMatches}(object, timeseries.labels = NULL,
  patterns.labels = NULL)
}
\arguments{
\item{object}{an object of class twdtwMatches.}

\item{timeseries.labels}{a vector with labels of the time series.}

\item{patterns.labels}{a vector with labels of the patterns.}
}
\value{
a list with TWDTW results or an object \code{\link[dtwSat]{twdtwTimeSeries-class}}.
}
\description{
Get elements from \code{\link[dtwSat]{twdtwMatches-class}} objects.
}
\examples{
# Getting patterns from objects of class twdtwMatches
patt = twdtwTimeSeries(MOD13Q1.patterns.list)
ts = twdtwTimeSeries(MOD13Q1.ts.list)
mat = twdtwApply(x=ts, y=patt, weight.fun=logisticWeight(-0.1,100), keep=TRUE)
getPatterns(mat)
getTimeSeries(mat)
getAlignments(mat)
getMatches(mat)
getInternals(mat)

}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwMatches-class}}, and
\code{\link[dtwSat]{twdtwApply}}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
