% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel_to_date.R
\name{dtt_excel_to_date}
\alias{dtt_excel_to_date}
\title{Convert Excel dates to dates.}
\usage{
dtt_excel_to_date(x, modern = TRUE, ...)
}
\arguments{
\item{x}{A vector of numbers to convert.}

\item{modern}{A flag specifying whether to use the modern or old Excel date
system.}

\item{...}{Unused.}
}
\value{
A floored Date vector.
}
\description{
Converts Excel dates encoded as serial numbers to date class.
}
\details{
Defaults to the modern Excel date encoding system. Excel for Mac
2008 and earlier Mac versions of Excel use a different date system. If the
date 2016-01-01 is represented by 42370, it's the modern system. If it's
40908, it's the old system.
}
\examples{
dtt_excel_to_date(42370)
dtt_excel_to_date(40908, modern = FALSE)
}
\seealso{
Other floor: 
\code{\link{dtt_date_time}()},
\code{\link{dtt_date}()},
\code{\link{dtt_floored}()},
\code{\link{dtt_floor}()},
\code{\link{dtt_set_time}()}
}
\concept{floor}
