% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{pos_eigen}
\alias{pos_eigen}
\alias{remove_attr}
\alias{outlier_correct_column}
\alias{outlier_correct}
\title{Utility functions}
\usage{
pos_eigen(H)

remove_attr(object)

outlier_correct_column(x)

outlier_correct(X)
}
\arguments{
\item{H}{symmetric matrix of full rank.}

\item{object}{vector or matrix.}

\item{x}{vector}

\item{X}{matrix}
}
\value{
\code{pos_eigen} returns a list with three elements: 1) Matrix with positive eigenvalues, 2) Matrix with square root of positive eigenvalues and 3) Matrix with inverse positive eigenvalues.
\code{remove_attr} returns the input object without attributes.
}
\description{
Collection of utility functions.
}
\details{
Collection of utility functions which are for internal usage. \code{pos_eigen} takes a symmetric matrix \code{H} and returns matrix \code{I} with positive eigenvalues as well as square root and inverse square root
}
\section{Functions}{
\itemize{
\item \code{remove_attr()}: Remove attribute function

\item \code{outlier_correct_column()}: Correct -Inf, Inf, NaN, NA and outliers im vector

\item \code{outlier_correct()}: Correct -Inf, Inf, NaN, NA and outliers in matrix

}}
\examples{
H<-diag(3)*(-1)
pos_eigen(H)

x<-1
attr(x,"gradient")<-2
x<-remove_attr(x)

x<-matrix(c(-Inf, Inf, rnorm(10,0,10)),ncol=1)
outlier_correct(x)

}
\keyword{internal}
