% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expmodel.r
\name{exp_est}
\alias{exp_est}
\title{Estimate coefficients of a polynomial in Exponential-based Model}
\usage{
exp_est(deg, lmd, data, freq, verbose, stepvec)
}
\arguments{
\item{deg}{A degree of polynomial, which is positive even integer.}

\item{lmd}{A rate parameter of an exponential distribution, which
is positive.}

\item{data}{A numeric vector of a data set to be estimated.}

\item{freq}{A numeric vector of frequencies for a data set \code{data}.
The default value is \code{NULL}, which indicates that all frequencies are
equally one.
If \code{freq} is not \code{NULL}, then it should be the same length as \code{data}, and
all values should be positive integers.}

\item{verbose}{If \code{TRUE}, it shows a detail information about SDP solver.}

\item{stepvec}{It designates the stepsize for SDP solver.
If the problem is easy, i.e., the number of a data set are small and a degree
of a polynomial is small, then, for example, \code{0.9} might be ok.
If it looks difficult, then \code{c(0.5, 0.3)} might work.}
}
\value{
A \code{list}  of \verb{deg, lmd, aic, accuracy, coefficient vector}
}
\description{
Estimate coefficients of a polynomial in Exponential-based
model:
\deqn{\mathrm{poly}(x; \alpha) \mathrm{Exp}(x; \lambda)},
where \eqn{\alpha} is a coefficient vector, \eqn{\lambda} is a rate
parameter of an exponential distribution:
\deqn{\mathrm{Exp}(x; \lambda) := \lambda e^{-\lambda x}}.

Using \code{data} and optionally its frequencies \code{freq},
and a degree of a polynomial,
a rate parameter \code{lmd} of an exponential distribution,
it computes the coefficients of polynomial, along with
Akaike Information Criterion(AIC) and an accuracy information from
underlying SDP solver.
In general, the smaller the AIC is, the better the model is.
An \code{accuracy} around \code{1e-7} is a good indication for a computational
result of coefficients estimation.
}
\examples{
rlst <- exp_est(3, 1.0, mixexpgamma$n200, NULL, FALSE, c(0.7, 0.4))
}
\seealso{
\code{\link[=estimate.expmodel]{estimate.expmodel()}}
}
