% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_util_fun.R
\name{collapse_chars}
\alias{collapse_chars}
\title{Collapse character inputs \code{x} into a single string.}
\usage{
collapse_chars(x, sep = " ")
}
\arguments{
\item{x}{A vector (required), typically a character vector.}

\item{sep}{A character inserted as separator/delimiter 
between elements when collapsing multi-element strings of \code{x}.  
Default: \code{sep = " "} (i.e., insert 1 space between elements).}
}
\value{
A character vector (of length 1).
}
\description{
\code{collapse_chars} converts multi-element character inputs \code{x} 
into a single string of text (i.e., a character object of length 1), 
separating its elements by \code{sep}.
}
\details{
As \code{collapse_chars} is a wrapper around 
\code{paste(x, collapse = sep)}. 
It preserves spaces within the elements of \code{x}. 

The separator \code{sep} is only used when collapsing multi-element vectors 
and inserted between elements.

See \code{\link{chars_to_text}} for combining character vectors into text.
}
\examples{
collapse_chars(c("Hello", "world", "!"))
collapse_chars(c("_", " _ ", "  _  "), sep = "|")  # preserves spaces
writeLines(collapse_chars(c("Hello", "world", "!"), sep = "\n"))
collapse_chars(1:3, sep = "")

}
\seealso{
\code{\link{chars_to_text}} for combining character vectors into text; 
\code{\link{text_to_chars}} for splitting text into a vector of characters; 
\code{\link{text_to_words}} for splitting text into a vector of words; 
\code{\link{strsplit}} for splitting strings.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{chars_to_text}()},
\code{\link{count_chars}()},
\code{\link{count_chars_words}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
