% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_bias_normal.R
\name{utility_bias_normal}
\alias{utility_bias_normal}
\alias{utility_normal_L}
\alias{utility_normal_L2}
\alias{utility_normal_R}
\alias{utility_normal_R2}
\title{Utility function for bias adjustment programs with normally distributed outcomes.}
\usage{
utility_normal_L(
  n2,
  kappa,
  Adj,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3,
  fixed
)

utility_normal_L2(
  n2,
  kappa,
  Adj,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3,
  fixed
)

utility_normal_R(
  n2,
  kappa,
  Adj,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3,
  fixed
)

utility_normal_R2(
  n2,
  kappa,
  Adj,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3,
  fixed
)
}
\arguments{
\item{n2}{total sample size for phase II; must be even number}

\item{kappa}{threshold value for the go/no-go decision rule}

\item{Adj}{adjustment parameter}

\item{w}{weight for mixture prior distribution}

\item{Delta1}{assumed true treatment effect for standardized difference in means}

\item{Delta2}{assumed true treatment effect for standardized difference in means}

\item{in1}{amount of information for \code{Delta1} in terms of sample size}

\item{in2}{amount of information for \code{Delta2} in terms of sample size}

\item{a}{lower boundary for the truncation}

\item{b}{upper boundary for the truncation}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category \code{"small"}, default: 0}

\item{stepm1}{lower boundary for effect size category \code{"medium"} = upper boundary for effect size category "small" default: 0.5}

\item{stepl1}{lower boundary for effect size category \code{"large"} = upper boundary for effect size category "medium", default: 0.8}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE Delta1 is used as fixed effect}
}
\value{
The output of the functions \code{utility_normal_L()}, \code{utility_normal_L2()}, \code{utility_normal_R()} and \code{utility_normal_R2()} is the expected utility of the program.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in a further step maximized by the \code{optimal_bias_normal()} function.
}
\examples{
res <- utility_normal_L(kappa = 0.1, n2 = 50, Adj = 0, 
                                 alpha = 0.025, beta = 0.1, w = 0.3,
                                 Delta1 = 0.375, Delta2 = 0.625, 
                                 in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, 
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf, 
                                 steps1 = 0, stepm1 = 0.5, stepl1 = 0.8,
                                 b1 = 3000, b2 = 8000, b3 = 10000, 
                                 fixed = TRUE)
          res <- utility_normal_L2(kappa = 0.1, n2 = 50, Adj = 0, 
                                 alpha = 0.025, beta = 0.1, w = 0.3,
                                 Delta1 = 0.375, Delta2 = 0.625, 
                                 in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, 
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf, 
                                 steps1 = 0, stepm1 = 0.5, stepl1 = 0.8,
                                 b1 = 3000, b2 = 8000, b3 = 10000, 
                                 fixed = TRUE)
          res <- utility_normal_R(kappa = 0.1, n2 = 50, Adj = 1, 
                                 alpha = 0.025, beta = 0.1, w = 0.3,
                                 Delta1 = 0.375, Delta2 = 0.625, 
                                 in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, 
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf, 
                                 steps1 = 0, stepm1 = 0.5, stepl1 = 0.8,
                                 b1 = 3000, b2 = 8000, b3 = 10000, 
                                 fixed = TRUE)
          res <- utility_normal_R2(kappa = 0.1, n2 = 50, Adj = 1, 
                                 alpha = 0.025, beta = 0.1, w = 0.3,
                                 Delta1 = 0.375, Delta2 = 0.625, 
                                 in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, 
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf, 
                                 steps1 = 0, stepm1 = 0.5, stepl1 = 0.8,
                                 b1 = 3000, b2 = 8000, b3 = 10000, 
                                 fixed = TRUE)
}
\keyword{internal}
